package com.ejie.ab04b.dao.custom;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.DatosLocalizacionDaoImpl;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.ab04b.model.nora.Localidad;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * Ab0467s00DaoImpl generated by UDA, 21-Feb-2017 12:47:21.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class DatosLocalizacionCustomDaoImpl extends DatosLocalizacionDaoImpl
		implements DatosLocalizacionCustomDao {

	private static final String QUERY_SELECT = "SELECT t1.COD_LOCALIZACION_067 CODLOCALIZACION067, t1.COD_PROVINCIA_067 CODPROVINCIA067, t1.COD_COMARCA_067 CODCOMARCA067, t1.COD_MUNICIPIO_067 CODMUNICIPIO067, t1.COD_LOCALIDAD_067 CODLOCALIDAD067, t1.CALLE_067 CALLE067, t1.PORTAL_067 PORTAL067, t1.CODPOSTAL_067 CODPOSTAL067, t1.PISO_067 PISO067, t1.PUERTA_067 PUERTA067, t1.DESC_PROVINCIA DESCPROVINCIA, t1.DESC_MUNICIPIO DESCMUNICIPIO, t1.DESC_LOCALIDAD DESCLOCALIDAD FROM VDATOS_LOCALIZACION t1 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DatosLocalizacion> rwMap = new RowMapper<DatosLocalizacion>() {
		public DatosLocalizacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			DatosLocalizacion datosLocalizacion = new DatosLocalizacion(
					resultSet.getInt("CODLOCALIZACION067"), null,
					resultSet.getString("CODCOMARCA067"), null, null,
					resultSet.getString("CALLE067"),
					resultSet.getString("PORTAL067"),
					resultSet.getString("CODPOSTAL067"),
					resultSet.getString("PISO067"),
					resultSet.getString("PUERTA067"));

			Provincia provincia = new Provincia(
					resultSet.getString("CODPROVINCIA067"));
			provincia.setDescripcion(resultSet.getString("DESCPROVINCIA"));
			datosLocalizacion.setProvincia(provincia);

			Municipio municipio = new Municipio(
					resultSet.getString("CODMUNICIPIO067"));
			municipio.setDescripcion(resultSet.getString("DESCMUNICIPIO"));
			datosLocalizacion.setMunicipio(municipio);

			Localidad localidad = new Localidad(
					resultSet.getString("CODLOCALIDAD067"));
			localidad.setDescripcion(resultSet.getString("DESCLOCALIDAD"));
			datosLocalizacion.setLocalidad(localidad);

			return datosLocalizacion;
		}
	};

	/**
	 * Finds a single row in the Ab0467s00 table.
	 * 
	 *  ab0467s00
	 *            Ab0467s00
	 *  Ab0467s00
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @return the datos localizacion
	 */
	@Transactional(readOnly = true)
	public DatosLocalizacion vfind(DatosLocalizacion ab0467s00) {
		StringBuilder query = new StringBuilder(
				DatosLocalizacionCustomDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.COD_LOCALIZACION_067 = ? ");

		List<DatosLocalizacion> ab0467s00List = this.getJdbcTemplate().query(
				query.toString(), this.rwMap,
				ab0467s00.getCodLocalizacion067());
		return (DatosLocalizacion) DataAccessUtils.uniqueResult(ab0467s00List);
	}

	/**
	 * Finds a list of rows in the Ab0467s00 table.
	 * 
	 *  ab0467s00
	 *            Ab0467s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0467s00>
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DatosLocalizacion> vfindAll(DatosLocalizacion ab0467s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				DatosLocalizacionCustomDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0467s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DatosLocalizacion>) this.getJdbcTemplate()
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0467s00 entity
	 * 
	 *  ab0467s00
	 *            Ab0467s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DatosLocalizacion ab0467s00) {

		StringBuilder where = new StringBuilder(
				DatosLocalizacionCustomDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0467s00 != null && ab0467s00.getCodLocalizacion067() != null) {
			where.append(" AND t1.COD_LOCALIZACION_067 = ?");
			params.add(ab0467s00.getCodLocalizacion067());
		}
		if (ab0467s00 != null && ab0467s00.getProvincia() != null
				&& ab0467s00.getProvincia().getCodProvincia() != null) {
			where.append(" AND t1.COD_PROVINCIA_067 = ?");
			params.add(ab0467s00.getProvincia().getCodProvincia());
		}
		if (ab0467s00 != null && ab0467s00.getCodComarca067() != null) {
			where.append(" AND t1.COD_COMARCA_067 = ?");
			params.add(ab0467s00.getCodComarca067());
		}
		if (ab0467s00 != null && ab0467s00.getMunicipio() != null
				&& ab0467s00.getMunicipio().getCodMunicipio() != null) {
			where.append(" AND t1.COD_MUNICIPIO_067 = ?");
			params.add(ab0467s00.getMunicipio().getCodMunicipio());
		}
		if (ab0467s00 != null && ab0467s00.getLocalidad() != null
				&& ab0467s00.getLocalidad().getCodLocalidad() != null) {
			where.append(" AND t1.COD_LOCALIDAD_067 = ?");
			params.add(ab0467s00.getLocalidad().getCodLocalidad());
		}
		if (ab0467s00 != null && ab0467s00.getCalle067() != null) {
			where.append(" AND t1.CALLE_067 = ?");
			params.add(ab0467s00.getCalle067());
		}
		if (ab0467s00 != null && ab0467s00.getPortal067() != null) {
			where.append(" AND t1.PORTAL_067 = ?");
			params.add(ab0467s00.getPortal067());
		}
		if (ab0467s00 != null && ab0467s00.getCodpostal067() != null) {
			where.append(" AND t1.CODPOSTAL_067 = ?");
			params.add(ab0467s00.getCodpostal067());
		}
		if (ab0467s00 != null && ab0467s00.getPiso067() != null) {
			where.append(" AND t1.PISO_067 = ?");
			params.add(ab0467s00.getPiso067());
		}
		if (ab0467s00 != null && ab0467s00.getPuerta067() != null) {
			where.append(" AND t1.PUERTA_067 = ?");
			params.add(ab0467s00.getPuerta067());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

}
